set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Figure 8

**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/

	*Decade dummy
	gen decade=1970 if year<=1980
	replace decade=1980 if year>1980&year<=1990
	replace decade=1990 if year>1990&year<=2000
	replace decade=2000 if year>2000
	tab decade, gen(d)	
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP	
	
	keep country cross code sector_short decade year D1_lnlaborshare D1_lnEMP D1_LP1_EMP weight*	
	collapse (mean) D1_lnlaborshare D1_lnEMP D1_LP1_EMP weight*, by(sector_short code decade) /*mean across country-years within decades*/


**2. Make Figure 8, top panel

	twoway 	(scatter D1_lnEMP D1_LP1_EMP if decade==1970, mcolor(navy) msymbol(+) ///
				legend(order(1 "1970s" 3 "1980s" 5 "1990s" 7 "2000s")) ///
				bgcolor(white) plotregion(color(white)) graphregion(color(white)) ///
				ytitle("Average annual employment change" "(log points)") xtitle("Average annual TFP growth (log points)") ///
				note("Unweighted average across country-years, lines are weighted linear fits by decade.")) ///
				(lfit D1_lnEMP  D1_LP1_EMP [w=weight] if decade==1970, lcolor(navy) legend(rows(1))) ///
				(scatter D1_lnEMP  D1_LP1_EMP if decade==1980, mcolor(maroon) msymbol(O)) ///		
				(lfit D1_lnEMP  D1_LP1_EMP [w=weight] if decade==1980, lcolor(maroon)) ///
				(scatter D1_lnEMP  D1_LP1_EMP if decade==1990, mcolor(forest_green) msymbol(D)) ///		
				(lfit D1_lnEMP  D1_LP1_EMP [w=weight] if decade==1990, lcolor(forest_green)) ///
				(scatter D1_lnEMP  D1_LP1_EMP if decade==2000, mcolor(dkorange) msymbol(T)) ///		
				(lfit D1_lnEMP D1_LP1_EMP [w=weight] if decade==2000, lcolor(dkorange)) 			
	graph export "$path_out\Fig8A.eps", as(eps) replace	


**3. Make Figure 8, bottom panel
	twoway 	(scatter D1_lnlaborshare D1_LP1_EMP if decade==1970, mcolor(navy) msymbol(+) ///
				legend(order(1 "1970s" 3 "1980s" 5 "1990s" 7 "2000s")) ///
				bgcolor(white) plotregion(color(white)) graphregion(color(white)) ///
				ytitle("Average annual labor share change" "(log points)") xtitle("Average annual TFP growth (log points)") ///
				note("Unweighted average across country-years, lines are weighted linear fits by decade.")) ///
				(lfit D1_lnlaborshare D1_LP1_EMP [w=weight_VA] if decade==1970, lcolor(navy) legend(rows(1))) ///
				(scatter D1_lnlaborshare D1_LP1_EMP if decade==1980, mcolor(maroon) msymbol(O)) ///		
				(lfit D1_lnlaborshare D1_LP1_EMP [w=weight_VA] if decade==1980, lcolor(maroon)) ///
				(scatter D1_lnlaborshare D1_LP1_EMP if decade==1990, mcolor(forest_green) msymbol(D)) ///		
				(lfit D1_lnlaborshare D1_LP1_EMP [w=weight_VA] if decade==1990, lcolor(forest_green)) ///
				(scatter D1_lnlaborshare D1_LP1_EMP if decade==2000, mcolor(dkorange) msymbol(T)) ///		
				(lfit D1_lnlaborshare D1_LP1_EMP [w=weight_VA] if decade==2000, lcolor(dkorange)) 			
	graph export "$path_out\Fig8B.eps", as(eps) replace					
	

